//
//  GSAnnotation.h
//  GlyphsCore
//
//  Created by Georg Seifert on 28.05.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <GlyphsCore/GSElement.h>

@class GSHandle;

/**
The Type of the annotation
*/
typedef NS_ENUM(NSUInteger, GSAnnotationType) {
	/**
	The tool is in Selection mode
	*/
	GSAnnotationTypeSelect = 0,
	/**
	Text
	*/
	GSAnnotationTypeText = 1,
	/**
	Arrow
	*/
	GSAnnotationTypeArrow = 2,
	/**
	Circle
	*/
	GSAnnotationTypeCircle = 3,
	/**
	Plus
	*/
	GSAnnotationTypePlus = 4,
	/**
	Minus
	*/
	GSAnnotationTypeMinus = 5
};

/**
The annotation object
*/

@interface GSAnnotation : GSElement {
	GSAnnotationType _type;
	NSString *_text;
	CGFloat _angle;
	CGFloat _width;
}

/**
The type of the annotation
*/
@property (nonatomic, assign) GSAnnotationType type;
/**
The Text.

Only available if type is GSAnnotationTypeText
*/
@property (nonatomic, strong) NSString *text;
/**
The angle of the element.

Only available for GSAnnotationTypeArrow
*/
@property (nonatomic, assign) CGFloat angle;

@property (nonatomic, assign) CGFloat width;
@property (nonatomic, assign) NSRect bounds;
@property (nonatomic, strong) GSHandle *activeHandle;

- (NSRect)handleRectForScale:(CGFloat)scale;
- (NSPoint)handlePositionForScale:(CGFloat)scale;
@end
